import itertools
import json
import os
import re
import sys
from builtins import print, Exception, len, iter, classmethod, staticmethod
from enum import Enum

import requests
import yaml
from requests.auth import HTTPBasicAuth

global sbce_fqdn, global_dat_file
success_map = {}

turn_profile_map = {}
network_mgmt_map = {}
tls_client_map = {}
tls_server_map = {}
reverse_proxy_map = {}
sip_server_map = {}
signaling_interface_map = {}
media_interface_map = {}
server_profile_map = {}
routing_profile_map = {}
application_rule_map = {}
endpoint_policy_map ={}

token = "dummyToken"
auth_user = ""
auth_passwd = ""


class APIDefs(Enum):
    NETWORK_MANAGEMENT = "/api/config/v1/network-management/networks"
    CERTIFICATES = "/api/config/v1/certificates/"
    TLS_CLIENT_PROFILES = "/api/config/v1/tls-client-profiles"
    TLS_SERVER_PROFILES = "/api/config/v1/tls-server-profiles"
    REVERSE_PROXY_PROFILES = "/api/config/v1/reverse-proxy-profiles"
    REVERSE_PROXY_RELAYS = "/api/config/v1/reverse-proxy-relays"
    TURN_STUN_PROFILES = "/api/config/v1/turn-stun-profiles"
    TURN_STUN_RELAYS = "/api/config/v1/turn-stun-relays"
    LOAD_MONITORING_PROFILES = "/api/config/v1/load-monitoring-profiles"
    SIP_SERVER_PROFILES = "/api/config/v1/sip-server-profiles"
    SIGNALING_INTERFACES = "/api/config/v1/signaling-interfaces"
    MEDIA_INTERFACES = "/api/config/v1/media-interfaces"
    SIP_ROUTING_PROFILES = "/api/config/v1/routing-profiles"
    SIP_SERVER_FLOWS = "/api/config/v1/sip-server-flows"
    SIP_SUBSCRIBER_FLOWS = "/api/config/v1/sip-subscriber-flows"
    FEATURE_CONTROL = "/api/config/v1/feature-control"
    APPLICATION_RULE = "/api/config/v1/application-rules"
    END_POINT_POLICY = "/api/config/v1/endpoint-policy-groups"
    API_TOKEN = "/api/auth/v1/token"

    def __str__(self):
        return self.name


class APIUtilities:
    def __init__(self, dat_file):
        global global_dat_file
        global_dat_file = dat_file
        self._sbce_config(dat_file)

    @classmethod
    def _sbce_config(cls, dat_file):
        global sbce_fqdn
        global auth_user
        global auth_passwd
        config_data = cls.file_utils("SBCE Config")
        data_dict = yaml.safe_load(config_data[0])
        sbce_fqdn = data_dict["managementIp"].strip()
        auth_user = data_dict["authUserName"].strip()
        auth_passwd = data_dict["authPassword"].strip()

        print("SBCE IP %s" % sbce_fqdn)

    def _url(path):
        global sbce_fqdn
        return 'https://' + sbce_fqdn + path

    @staticmethod
    def getToken(path):
        # header_tuple = {'Authorization': 'Basic dGVzdC11c2VyOnBhc3N3b3Jk'}
        global token
        # token = requests.post(APIUtilities._url(path),headers=header_tuple, verify=False)

        token = requests.post(APIUtilities._url(path), auth=HTTPBasicAuth(auth_user, auth_passwd), verify=False)
        if (token.status_code != 200):
            print("not able to generate token.")
            print("request status:%s" % token.status_code)
            print("response: %s" % token.json())
            sys.exit(1)

        print(token.json())

    @staticmethod
    def get_request(api_path, primary_id=None):
        if primary_id != None:
            get_request_url = "%s/%s" % (APIUtilities._url(api_path), primary_id)
        else:
            get_request_url = APIUtilities._url(api_path)

        global token
        auth_header = {'Authorization': 'Bearer ' + token.json()}

        print(get_request_url)

        resp = requests.get(get_request_url, headers=auth_header, verify=False)

        if (resp.status_code == 401):
            APIUtilities.getToken(APIDefs.API_TOKEN.value)
            APIUtilities.get_request(api_path, primary_id)

        # print('Response %s' % resp.status_code)
        # print('data = %s' % resp.json())
        return resp.json()
        
    @staticmethod
    def get_api_name(api_path):
        result_list = api_path.rsplit("/",1)
        return result_list.pop()
        
    @staticmethod
    def create_map(api_path,resp):
        api_name = APIUtilities.get_api_name(api_path)
        print(api_name)
        if(api_name == "turn-stun-profiles"):
            global turn_profile_map
            for j in resp:
                turn_profile_map[j['profileName']] = j['profileId']
        
        if(api_name == "networks"):
            global network_mgmt_map
            for j in resp:
                network_list = j['networkAddresses']
                for i in network_list:
                    print("Iterator = ")
                    print(i)
                    network_mgmt_map[i['ipAddress']] = i['networkAddressId']
        
        if(api_name == "tls-client-profiles"):
            global tls_client_map
            for j in resp:
                tls_client_map[j['profileName']] = j['profileId']
        
        if(api_name == "tls-server-profiles"):
            global tls_server_map
            for j in resp:
                tls_server_map[j['profileName']] = j['profileId']
        
        if(api_name == "reverse-proxy-profiles"):
            global reverse_proxy_map
            for j in resp:
                reverse_proxy_map[j['profileName']] = j['profileId']
        
        if(api_name == "sip-server-profiles"):
            global sip_server_map
            for j in resp:
                sip_server_map[j['serverName']] = j['serverId']
        
        if(api_name == "signaling-interfaces"):
            global signaling_interface_map
            for j in resp:
                signaling_interface_map[j['signalingName']] = j['signalingId']
                
        if(api_name == "media-interfaces"):
            global media_interface_map
            for j in resp:
                media_interface_map[j['mediaName']] = j['mediaId']
        
        if(api_name == "sip-server-profiles"):
            global server_profile_map
            for j in resp:
                server_profile_map[j['serverName']] = j['serverId']
        
        if(api_name == "routing-profiles"):
            global routing_profile_map
            for j in resp:
                routing_profile_map[j['profileName']] = j['profileId']
                    
        if(api_name == "application-rules"):
            global application_rule_map
            for j in resp:
                application_rule_map[j['ruleName']] = j['ruleId']
        
        if(api_name == "endpoint-policy-groups"):
            global endpoint_policy_map
            for j in resp:
                endpoint_policy_map[j['policyName']] = j['policyId']

    @staticmethod
    def send_request(api_path, primary_id, data, parameter=False, files=None):
        try:
            global token
            auth_header = {'Authorization': 'Bearer ' + token.json()}
            if parameter:
                print(APIUtilities._url(api_path))
                resp = requests.post(APIUtilities._url(api_path), headers=auth_header, verify=False)
            elif files:
                print(APIUtilities._url(api_path))
                resp = requests.post(APIUtilities._url(api_path), headers=auth_header, data=data, files=files,
                                     verify=False)
            else:
                print(APIUtilities._url(api_path))
                resp = requests.post(APIUtilities._url(api_path), headers=auth_header, json=data, verify=False)

            print("Returned response: " + str(resp.status_code))

            print(resp)

            if resp.status_code == 401:
                APIUtilities.getToken(APIDefs.API_TOKEN.value)
                APIUtilities.send_request(api_path, primary_id, data, parameter)

            if resp.status_code != 200:
                print('POST {}'.format(resp.status_code))
                for line in resp.iter_lines():
                    returned_text = resp.text
                    print("text %s" %returned_text)
                    if(re.search("Name already exist", returned_text)):
                        print("Same name configuration has already present, no changes will be done")
                        return ""
                    else:
                        print(resp.raise_for_status())
            if primary_id == "":
                if api_path.startswith(APIDefs.CERTIFICATES.value):
                    certificate_type = os.path.basename(api_path)
                    certificate_filepath = (files["certificatePayload"][0])
                    cert_detail_tuple = {certificate_type: (os.path.basename(certificate_filepath))}    
                    print(cert_detail_tuple)
                    print(files)
                    if "privateKeyPayload" in files:
                        cert_detail_tuple["key"] = os.path.basename(files["privateKeyPayload"][0])
                    return cert_detail_tuple
                else:
                    # When the API doesn't return anything we will send empty ID.
                    # For delete, we won't be able to delete also
                    return ""

            print('data = %s' % resp.json())
            if parameter:
                return ""

            return resp.json()[primary_id]

        except Exception as e:
            print("Error in send request %s" % e)
            return -1

    @staticmethod
    def delete_request(apiName, id):
        try:
            global token
            auth_header = {'Authorization': 'Bearer ' + token.json()}
            if apiName not in APIDefs._member_names_:
                print("Please enter correct API Name")
                sys.exit(1)
            if apiName == "CERTIFICATES":
                for k,v in id.items():
                    delete_url = os.path.join(APIUtilities._url(APIDefs[apiName].value),k)+"/"+v
                    print("Delete URL %s"%delete_url)
                    resp = requests.delete(delete_url,headers=auth_header,verify=False)
            elif id == "" :
                print("Cannot delete empty ID")
                return
            else:
                delete_url = APIUtilities._url(APIDefs[apiName].value)+"/"+str(id)
                print("Delete URL %s"%delete_url)
                resp = requests.delete(delete_url,headers=auth_header,verify=False) 

            if (resp.status_code == 401):
                APIUtilities.getToken(APIDefs.API_TOKEN.value)
                APIUtilities.delete_request(apiName, id)

            if resp.status_code != 200:
                print('DELETE {}'.format(resp.status_code))
                for line in resp.iter_lines():
                    print(line)
                print(resp.raise_for_status())
                sys.exit(1)
            else:
                print("Delete successful for API {} and ID {}".format(apiName, id))

        except Exception as e:
            print("Error in delete request : %s" % e)

    @staticmethod
    def file_utils(api_name):
        reader = open(global_dat_file, 'r').read()
        data_all = []
        api_name = '#%s' % api_name
        all_indexes = [m.start() for m in re.finditer(api_name, reader)]
        for index in all_indexes:
            data = reader[index + len(api_name):]
            left_index = data.find('#API')
            if left_index == -1:
                data = data[:]
            else:
                data = data[:left_index]
            data_all.append(data)
        if not data_all:
            print("Data not found in dat file")
            raise Exception("DATA_NOT_FOUND")
        return data_all

    @staticmethod
    def list_to_dict(list_data):
        it = iter(list_data)
        data_dict = dict(itertools.zip_longest(it, it))
        for k, v in data_dict.items():
            if v == "null":
                data_dict[k] = None
            if v == "EMPTY_STR" or v == "":
                data_dict[k] = ""
        print(data_dict)
        return data_dict

    @staticmethod
    def check_id(ids, api_name):
        try:
            for id in ids:
                if id != -1:
                    success_map.setdefault(api_name, [])
                    success_map[api_name].append(id)
                else:
                    print("Failed to add %s, rollbacking all the data %s." % (api_name, success_map))
                    APIUtilities.bulk_delete()
        except Exception as e:
            print("Error occurred {}, rollbacking all the data {}".format(e, success_map))

    @staticmethod
    def bulk_delete():
        global success_map
        
        print("Entered bulk delete")
        print (success_map)
        new_list = list(success_map.items())
        new_list = new_list[::-1]
        
        success_map = dict(new_list)        
        
        for api_name, ids in success_map.items():
            for id in ids:
                APIUtilities.delete_request(api_name, id)
        sys.exit(1)

    @staticmethod
    def modify_with_map_data(data_dict, api_path):
        try:
            api_name = APIUtilities.get_api_name(api_path)
            print("API NAME = " )
            print(api_name)
            if (api_name == "turn-stun-relays"):
                data_dict['turnStunProfileId'] = turn_profile_map[data_dict['turnProfileName']]
                data_dict['listenIpId'] = network_mgmt_map[data_dict['listenIp']]
                data_dict['mediaRelayIpId'] = network_mgmt_map[data_dict['mediaRelayIp']]
                del data_dict['turnProfileName']
                del data_dict['listenIp']
                del data_dict['mediaRelayIp']
                return data_dict
        
            if(api_name == "load-monitoring-profiles"):
                data_dict['listenIpId'] = network_mgmt_map[data_dict['listenIp']]
                del data_dict['listenIp']
                if('listenTlsProfileName' in data_dict):
                    data_dict['listenTlsProfileId'] = tls_server_map[data_dict['listenTlsProfileName']]
                    del data_dict['listenTlsProfileName']
                return data_dict
                
            if(api_name == "turn-stun-profiles"):
                if('tlsServerProfileName' in data_dict):
                    data_dict['tlsServerProfileId'] = tls_server_map[data_dict['tlsServerProfileName']]
                    del data_dict['tlsServerProfileName']
                return data_dict
        
            if(api_name == "reverse-proxy-relays"):
                data_dict['listenIpId'] = network_mgmt_map[data_dict['listenIp']]
                data_dict['connectIpId'] = network_mgmt_map[data_dict['connectIp']]
                if('serverTlsProfileName' in data_dict):
                    data_dict['serverTlsProfileId'] = tls_client_map[data_dict['serverTlsProfileName']]
                    del data_dict['serverTlsProfileName']
                if('listenTlsProfileName' in data_dict):
                    data_dict['listenTlsProfileId'] = tls_server_map[data_dict['listenTlsProfileName']]
                    del data_dict['listenTlsProfileName']
                if('reverseProxyProfileName' in data_dict):
                    data_dict['reverseProxyProfileId'] = reverse_proxy_map[data_dict['reverseProxyProfileName']]
                    del data_dict['reverseProxyProfileName']
                del data_dict['listenIp']
                del data_dict['connectIp']
                return data_dict
                
            if(api_name == "signaling-interfaces"):
                data_dict['networkId'] = network_mgmt_map[data_dict['signalingIp']]
                if('tlsProfileName' in data_dict):
                    data_dict['tlsProfileId'] = tls_server_map[data_dict['tlsProfileName']]
                    del data_dict['tlsProfileName']
                del data_dict['signalingIp']
                return data_dict
                
            if(api_name == "sip-subscriber-flows")
                data_dict['signalingInterfaceId'] = signaling_interface_map[data_dict['signalingInterfaceName']]
                data_dict['mediaInterfaceId'] = media_interface_map[data_dict['mediaInterfaceName']]
                data_dict['receivingInterfaceId'] = signaling_interface_map[data_dict['receivingInterfaceName']]
                data_dict['endPointPolicyGroupId'] = endpoint_policy_map[data_dict['endPointPolicyGroupName']]
                del data_dict['endPointPolicyGroupName']
                del data_dict['receivingInterfaceName']
                del data_dict['mediaInterfaceName']
                del data_dict['signalingInterfaceName']
                return data_dict
                
            if(api_name == "media-interfaces"):
                data_dict['networkId'] = network_mgmt_map[data_dict['mediaIp']]
                if('tlsProfileName' in data_dict):
                    data_dict['tlsProfileId'] = tls_server_map[data_dict['tlsProfileName']]
                    del data_dict['tlsProfileName']
                del data_dict['mediaIp']
                return data_dict
                
            if(api_name == "sip-server-profiles"):
                if('tlsClientProfileName' in data_dict):
                    data_dict['tlsClientProfileId'] = tls_client_map[data_dict['tlsClientProfileName']]
                    del data_dict['tlsClientProfileName']
                return data_dict
                
            
            if(api_name == "sip-server-flows"):
                data_dict['sipServerProfileId'] = server_profile_map[data_dict['sipServerProfileName']]
                data_dict['receivedInterfaceId'] = signaling_interface_map[data_dict['receivedInterfaceName']]
                data_dict['signalingInterfaceId'] = signaling_interface_map[data_dict['signalingInterfaceName']]
                data_dict['mediaInterfaceId'] = media_interface_map[data_dict['mediaInterfaceName']]
                data_dict['endPointPolicyGroupId'] = endpoint_policy_map[data_dict['endPointPolicyGroupName']]
                data_dict['routingProfileId'] = routing_profile_map[data_dict['routingProfileName']]
                del data_dict['sipServerProfileName']
                del data_dict['receivedInterfaceName']
                del data_dict['signalingInterfaceName']
                del data_dict['mediaInterfaceName']
                del data_dict['endPointPolicyGroupName']
                del data_dict['routingProfileName']
                return data_dict
                
            if(api_name == "endpoint-policy-groups"):
                data_dict['applicationRuleId'] = application_rule_map[data_dict['applicationRuleName']]
                del data_dict['applicationRuleName']
            return data_dict
        except Exception as e:
            print("Error in solving request parameters: %s" % e)    
    

    @staticmethod
    def return_result(config_data, api_name, primary_key, default_data={}):
        try : 
            result = []
            files = {}
            print("API NAME:")
            print(api_name)
            # print(default_data)
            for data in config_data:
                # print("Data before safe load: " + data)
                print(data)
                data_dict = yaml.safe_load(data)
                print(data_dict)
                # print("data_dict before update: " + str(data_dict))
                if data_dict is not None:
                    if api_name == APIDefs.CERTIFICATES.value:
                        result.append(APIUtilities.certificate_requests(data_dict))
                    else:
                        modified_dict = APIUtilities.modify_with_map_data(data_dict, api_name)
                        modified_dict.update(default_data)
                        print("Print Final Data:")
                        print(data_dict)
                        # print(data_dict)
                        print(json.dumps(modified_dict))
                        result.append(APIUtilities.send_request(api_name, primary_key, modified_dict))
        except Exception as e:
            print("Error in return result %s" %e)
        finally:
            return result

    @staticmethod
    def certificate_requests(data_dict):
        cert_file_name = data_dict["certificatePayload"]
        files = {"certificatePayload": (cert_file_name, open(cert_file_name, 'rb'))}
        data_dict.pop("certificatePayload")
        key_file_name = data_dict["privateKeyPayload"]
        if key_file_name is not None:
            files["privateKeyPayload"] = (key_file_name, open(key_file_name, 'rb'))
            data_dict.pop("privateKeyPayload")
        ca_file_name = data_dict["trustChainPayload"]
        if ca_file_name is not None:
            files["trustChainPayload"] = (ca_file_name, open(ca_file_name, 'rb'))
            data_dict.pop("trustChainPayload")
        api_name = APIDefs.CERTIFICATES.value + data_dict["certificateType"]
        print("sending request for certificate type %s" %data_dict["certificateType"])
        return APIUtilities.send_request(api_name, "", data_dict, files=files)
